<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;

    public function neighborhoods()
    {
        return $this->belongsTo('App\Models\Neighborhood', 'neighborhood_id');
    }

    public function classifications()
    {
        return $this->belongsToMany('App\Models\Classification', 'restaurant_classifications');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer');
    }

    public function clients()
    {
        return $this->belongsToMany('App\Models\Client', 'reviews')->withPivot('coment','emoji');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function commissions()
    {
        return $this->hasMany('FeesPaid');
    }

    public function notifications()
    {
        return $this->morphMany('App\Models\Notification', 'users');
    }

    public function tokens()
    {
        return $this->morphMany('App\Models\Token', 'users');
    }

}